VERSION 5.00
Begin VB.Form Clock 
   BackColor       =   &H00404040&
   Caption         =   "Alarm Clock 2000 Professional"
   ClientHeight    =   4380
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   7260
   LinkTopic       =   "Form1"
   ScaleHeight     =   4380
   ScaleWidth      =   7260
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton ViewEventsButton 
      Caption         =   "View Scheduled Events"
      Height          =   495
      Left            =   4200
      TabIndex        =   15
      Top             =   1920
      Width           =   1575
   End
   Begin VB.CheckBox MilitaryModeCheck 
      BackColor       =   &H00404040&
      Caption         =   "Military Time"
      ForeColor       =   &H00E0E0E0&
      Height          =   255
      Left            =   2400
      TabIndex        =   12
      Top             =   3480
      Width           =   1215
   End
   Begin VB.CommandButton SetMinuteButton 
      Caption         =   "Set Minute"
      Height          =   495
      Index           =   2
      Left            =   480
      TabIndex        =   9
      Top             =   2760
      Width           =   1215
   End
   Begin VB.CommandButton SetSecondButton 
      Caption         =   "Set Second"
      Height          =   495
      Index           =   1
      Left            =   480
      TabIndex        =   8
      Top             =   3360
      Width           =   1215
   End
   Begin VB.CommandButton SetHourButton 
      Caption         =   "Set Hour"
      Height          =   495
      Index           =   0
      Left            =   480
      TabIndex        =   7
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CommandButton StopClock 
      Caption         =   "Stop Clock"
      Height          =   495
      Left            =   2280
      TabIndex        =   6
      Top             =   2640
      Width           =   1455
   End
   Begin VB.CommandButton StartClock 
      Caption         =   "Start Clock"
      Height          =   495
      Left            =   2280
      TabIndex        =   5
      Top             =   1920
      Width           =   1455
   End
   Begin VB.Timer Ticker 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   6720
      Top             =   120
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00404040&
      ForeColor       =   &H00808080&
      Height          =   615
      Left            =   2280
      TabIndex        =   13
      Top             =   3240
      Width           =   1455
   End
   Begin VB.Frame Frame2 
      Appearance      =   0  'Flat
      BackColor       =   &H00404040&
      Caption         =   "Set Clock"
      ForeColor       =   &H00E0E0E0&
      Height          =   2295
      Left            =   240
      TabIndex        =   14
      Top             =   1800
      Width           =   1695
   End
   Begin VB.Label AMPMDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      Caption         =   "AM"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   36
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1065
      Left            =   5640
      TabIndex        =   10
      Top             =   480
      Width           =   1380
   End
   Begin VB.Label Colon2 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      Caption         =   ":"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   48
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   3600
      TabIndex        =   4
      Top             =   240
      Width           =   705
   End
   Begin VB.Label HoursDisplay 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00000000&
      Caption         =   "12"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   48
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   240
      TabIndex        =   2
      Top             =   240
      Width           =   1380
   End
   Begin VB.Label MinutesDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      Caption         =   "00"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   48
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   2160
      TabIndex        =   1
      Top             =   240
      Width           =   1500
   End
   Begin VB.Label SecondsDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      Caption         =   "00"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   48
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   4200
      TabIndex        =   0
      Top             =   240
      Width           =   1500
   End
   Begin VB.Label Colon1 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      Caption         =   ":"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   48
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   1560
      TabIndex        =   3
      Top             =   240
      Width           =   705
   End
   Begin VB.Label AMPMBack 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   36
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000C000&
      Height          =   1305
      Left            =   5640
      TabIndex        =   11
      Top             =   240
      Width           =   1380
   End
   Begin VB.Menu AlarmClockMenu 
      Caption         =   "&Alarm Clock"
      Index           =   0
      Begin VB.Menu HideControlsOption 
         Caption         =   "Hide Controls"
         Index           =   1
         Shortcut        =   ^H
      End
      Begin VB.Menu ShowControlsOption 
         Caption         =   "Show Controls"
         Index           =   2
         Shortcut        =   ^S
      End
      Begin VB.Menu Exit 
         Caption         =   "Exit"
         Index           =   3
      End
   End
End
Attribute VB_Name = "Clock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Public ClockSeconds As Seconds
Public ClockMinutes As Minutes
Public ClockHours As Hours
Public ClockRunning As Boolean
Public ClockScheduler As Scheduler
Public MilitaryMode As Boolean

Private Sub Exit_Click(Index As Integer)
    Unload Me
End Sub

Private Sub Form_Load()

    ' Initialize seconds
    Set ClockSeconds = New Seconds
    ClockSeconds.CurrentValue = 0
    
    ' Initialize minutes
    Set ClockMinutes = New Minutes
    ClockMinutes.CurrentValue = 0
    
    ' Initialize hours
    Set ClockHours = New Hours
    ClockHours.CurrentValue = 24
    
    ' Initialize Scheduler - this is mostly debug stuff
    Set ClockScheduler = New Scheduler
    ClockScheduler.Init
    Dim result As Boolean
    Dim i, j As Integer
    For i = 1 To 2
        For j = 1 To 60
            result = ClockScheduler.AddEvent(10, i, j, Msg, "Hello")
            'If i > 1 And j > 30 And j < 46 Then
            '    MsgBox result
            'End If
        Next j
    Next i
    
    
    
    ClockRunning = False
    MilitaryMode = False
    
End Sub


Private Sub HideControlsOption_Click(Index As Integer)
    Clock.Height = 2450
End Sub

Private Sub MilitaryModeCheck_Click()
    If MilitaryModeCheck.Value = Unchecked Then
        MilitaryMode = False
        AMPMDisplay.Visible = True
        AMPMBack.Visible = True
    Else
        MilitaryMode = True
        AMPMDisplay.Visible = False
        AMPMBack.Visible = False
    End If
    
    RefreshClock
End Sub

Private Sub SetHourButton_Click(Index As Integer)
    If ClockRunning Then
        NonModalWarning.Show
    Else
        frmSetHour.Show
    End If
End Sub

Private Sub SetMinuteButton_Click(Index As Integer)
    If ClockRunning Then
        NonModalWarning.Show
    Else
        frmSetMinute.Show
    End If
End Sub

Private Sub SetSecondButton_Click(Index As Integer)
    If ClockRunning Then
        NonModalWarning.Show
    Else
        frmSetSecond.Show
    End If
End Sub

Private Sub ShowControlsOption_Click(Index As Integer)
    Clock.Height = 5070
End Sub

Private Sub StartClock_Click()
    ClockRunning = True
    Ticker.Enabled = True
End Sub

Private Sub StopClock_Click()
    ClockRunning = False
    Ticker.Enabled = False
End Sub

Private Sub Ticker_Timer()
    
    ' Tick, tick, tick...
    If ClockSeconds.Increment = 0 Then
        If ClockMinutes.Increment = 0 Then
            ClockHours.Increment
        End If
    End If
    
    ' Show update
    RefreshClock
End Sub

Public Sub RefreshClock()
    SecondsDisplay.Caption = FormatMinsSecs(ClockSeconds.CurrentValue)
    MinutesDisplay.Caption = FormatMinsSecs(ClockMinutes.CurrentValue)
    
    If MilitaryMode Then
        HoursDisplay.Caption = ClockHours.CurrentValue
    Else
        If ClockHours.CurrentValue > 12 Then
            HoursDisplay.Caption = ClockHours.CurrentValue - 12
        Else
            HoursDisplay.Caption = ClockHours.CurrentValue
        End If
        
        If ClockHours.CurrentValue > 11 And ClockHours.CurrentValue < 24 Then
            AMPMDisplay.Caption = "PM"
        Else
            AMPMDisplay.Caption = "AM"
        End If
    End If
        
End Sub

Private Sub ViewEventsButton_Click()
    frmViewEvents.Show
End Sub
